<?php
session_start();

// Verifica si hay un mensaje de error en la URL
if (isset($_GET['error'])) {
    $error_type = $_GET['error'];
    $error_message = "";

    // Asigna un mensaje de error según el tipo de error
    switch ($error_type) {
        case "correo_invalido":
            $error_message = "El correo ingresado no existe en nuestra base de datos.";
            break;
        default:
            $error_message = "Ha ocurrido un error.";
            break;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Restablecer contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../css/estilos-caja.css">
    <link rel="shortcut icon" href="../img/favicon.png" type="image/x-icon">
</head>

<body>
    <div class="container">
        <h3 class="logo">mzChat</h3>
        <div class="login-container">
            <h4>Restablecer contraseña</h4>
            <!-- Formulario para restablecer contraseña -->
            <form action="restablecer_pass_proceso.php" method="post">
                <div class="mb-3">
                    <label for="registerEmail" class="form-label mb-0">Correo electrónico:</label>
                    <input type="email" class="form-control" id="registerEmail" name="email" required>
                </div>
                <button type="submit" class="btn btn-primary btn-acceso" name="register">Restablecer</button>
                <?php if (isset($error_message)) { ?>
                    <div class="alert alert-danger info-error"><?php echo $error_message; ?></div>
                <?php } ?>
            </form>

            <div class="links">
                <a href="../login.php">Regresar e iniciar sesión</a>
            </div>
        </div>
        <p class="copy">© <?php echo date("Y"); ?> mzChat. Desarrollado por Maxi Zamorano</p>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>