<?php
session_start();

// Verifica si hay un mensaje de error en la URL
$error_message = '';
if (isset($_GET['error'])) {
    $error_code = $_GET['error'];
    if ($error_code === 'verificacion_codigo') {
        $error_message = 'El código de verificación ingresado es incorrecto.';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../css/estilos-caja.css">
    <link rel="shortcut icon" href="../img/favicon.png" type="image/x-icon">
</head>
<body>
    <div class="container">
        <h3 class="logo">mzChat</h3>
        <div class="login-container">
            <h4>Verificación</h4>
            <!-- Formulario de inicio de sesión -->
            <form action="registro_completar.php" method="post">
                <div class="mb-2">
                    <div class="alert alert-info info-info">Te enviamos un correo con el codigo de verificación.</div>
                    <label for="verification_code" class="form-label mb-0">Ingrese el código de verificación:</label>
                    <input type="text" class="form-control" id="verification_code" name="verification_code" required>
                </div>
                <button type="submit" class="btn btn-primary btn-acceso" name="verificar">Verificar</button>
                <!-- Muesta el mensaje de error -->
                <?php if (!empty($error_message)) : ?>
                    <div class="alert alert-danger info-error"><?php echo $error_message; ?></div>
                <?php endif; ?>
            </form>
        </div>
        <p class="copy">© <?php echo date("Y"); ?> mzChat. Desarrollado por Maxi Zamorano</p>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>