<?php
session_start();

if(isset($_POST['register'])) {
    
    require_once '../db.php';
    
    // Obtiene los datos del formulario de registro y evitar el ingreso de codigo
    $firstname = htmlspecialchars($_POST['firstname']);
    $lastname = htmlspecialchars($_POST['lastname']);
    $username = htmlspecialchars($_POST['username']);
    $email = htmlspecialchars($_POST['email']);
    $password = $_POST['password'];

    // Valida el formato del nombre de usuario utilizando una expresión regular
    if (!preg_match("/^[a-zA-Z0-9_]{1,20}$/", $username)) {
        header("Location: ../registro.php?error=username_formato");
        exit;
    }

    // Valida la fortaleza de la contraseña utilizando una expresión regular
    if (!preg_match("/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d|\W).{8,}$/", $password)) {
        header("Location: ../registro.php?error=password");
        exit;
    }

    // Verifica si el correo electrónico ya existe en la base de datos
    $email_check_query = "SELECT * FROM usuarios WHERE email='$email' LIMIT 1";
    $email_check_result = mysqli_query($conn, $email_check_query);
    $email_exists = mysqli_fetch_assoc($email_check_result);

    if ($email_exists) {
        header("Location: ../registro.php?error=email");
        exit;
    }

    // Verifica si el nombre de usuario ya está en uso en la base de datos e ignora mayúsculas y minúsculas
    $username_check_query = "SELECT * FROM usuarios WHERE LOWER(username) = LOWER('$username') LIMIT 1";
    $username_check_result = mysqli_query($conn, $username_check_query);

    if (!$username_check_result) {
        die("Error en la consulta SQL: " . mysqli_error($conn));
    }

    $username_exists = mysqli_fetch_assoc($username_check_result);

    if ($username_exists) {
        header("Location: ../registro.php?error=username");
        exit;
    }

    // Almacena los datos del usuario en la sesión para la verificación que se realiza después
    $_SESSION['userdata'] = [
        'firstname' => $firstname,
        'lastname' => $lastname,
        'username' => $username,
        'email' => $email,
        'password' => $password
    ];

    // Genera un código de verificación único
    $verification_code = uniqid();

    // Almacena el código de verificación en la sesión
    $_SESSION['verification_code'] = $verification_code;

    // Carga la plantilla de correo para la verificación
    $email_template = file_get_contents('../templates-email/template_verificar.html');

    // Reemplaza codigo de la platilla.
    $email_template = str_replace('{{verification_code}}', $verification_code, $email_template);

    // Envía el correo de verificación
    $to = $email;
    $subject = 'Código de verificación de mzChat';
    $headers = 'MIME-Version: 1.0' . "\r\n" .
           'From: mzChat <no-reply@maxizamorano.com>' . "\r\n" .
           'Reply-To: no-reply@maxizamorano.com' . "\r\n" .
           'X-Mailer: PHP/' . phpversion() . "\r\n" .
           'Content-type: text/html; charset=UTF-8';

    mail($to, $subject, $email_template, $headers);

    // Redirecciona al usuario a la página de verificación de registro
    header("Location: registro_verificar.php");
    exit;

} else {
    header("Location: registro.php");
    exit;
}
?>
