<?php
session_start();

// Verificar si el usuario ya tiene una sesión iniciada
if (isset($_SESSION['username'])) {
    header("Location: panel.php");
    exit();
}

// Verificar si hay un parametro de error en la URL
if (isset($_GET['error'])) {
    $error_type = $_GET['error'];
    $error_message = "";

    // Se muestra un mensaje de error según el tipo de error
    switch ($error_type) {
        case "password":
            $error_message = "La contraseña debe tener al menos 8 caracteres, una letra mayúscula, una letra minúscula y un número o caracter especial.";
            break;
        case "email":
            $error_message = "El correo electrónico ya está en uso.";
            break;
        case "username":
            $error_message = "El nombre de usuario ya está en uso. Por favor, elige otro";
            break;
        case "username_formato":
            $error_message = "El nombre de usuario no es valido, maximo 20 carácteres y solo puedes usar mayúsculas, minúsculas, números y guiones bajos.";
            break;
        case "database":
            $error_message = "Error al registrar el usuario. Por favor, inténtalo de nuevo más tarde.";
            break;
        default:
            $error_message = "Ha ocurrido un error durante el registro. Por favor, inténtalo de nuevo.";
            break;
    }
}

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/estilos-caja.css">
    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon">
</head>

<body>
    <div class="container">
        <h3 class="logo">mzChat</h3>
        <div class="login-container">
            <h4>Registro</h4>

            <!-- Formulario de registro -->
            <form action="registro/registro_proceso.php" method="post">
                <div class="mb-1">
                    <label for="registerFirstname" class="form-label mb-0">Nombre:</label>
                    <input type="text" class="form-control" id="registerFirstname" name="firstname" required>
                </div>
                <div class="mb-1">
                    <label for="registerLastname" class="form-label mb-0">Apellido:</label>
                    <input type="text" class="form-control" id="registerLastname" name="lastname" required>
                </div>
                <div class="mb-1">
                    <label for="registerUsername" class="form-label mb-0">Nombre de usuario:</label>
                    <input type="text" class="form-control" id="registerUsername" name="username" required>
                </div>
                <div class="mb-1">
                    <label for="registerEmail" class="form-label mb-0">Correo electrónico:</label>
                    <input type="email" class="form-control" id="registerEmail" name="email" required>
                </div>
                <div class="mb-1">
                    <label for="registerPassword" class="form-label mb-0">Contraseña:</label>
                    <input type="password" class="form-control" id="registerPassword" name="password" required>
                </div>
                <div class="mb-1 form-check terminos">
                    <input type="checkbox" class="form-check-input" id="terminos" name="terminos" required>
                    <label class="form-check-label" for="terminos">Acepto los <a class="term" href="terminos_y_condiciones.html" target="_blank">términos y condiciones</a></label>
                </div>
                <button type="submit" class="btn btn-primary btn-acceso mt-2" name="register">Registrarse</button>
                <!-- Muestra un mensaje de error si en la URL hay algunos de los parametro mencionados al principio -->
                <?php if (isset($error_message)) { ?>
                    <div class="alert alert-danger info-error"><?php echo $error_message; ?></div>
                <?php } ?>
            </form>

            <div class="links">
                <a href="login.php">¿Ya tienes una cuenta? Inicia sesión</a>
            </div>
        </div>
        <p class="copy">© <?php echo date("Y"); ?> mzChat. Desarrollado por Maxi Zamorano</p>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>