<?php
session_start();

// Verifica si el usuario inició sesión
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// Verifica si se hizo clic en cerrar sesión
if (isset($_GET['logout'])) {
    session_destroy();

    header("Location: login.php");
    exit;
}

// Conexión a la base de datos
require_once 'db.php';

// Obtiene el nombre de usuario del perfil para mostrarlo
if (isset($_GET['usuario'])) {
    $profile_username = $_GET['usuario'];

    // Consulta la base de datos para mostrar la información del usuario
    $query = "SELECT * FROM usuarios WHERE username = '$profile_username'";
    $result = mysqli_query($conn, $query);

    // Verifica si el usuario existe
    if ($result && mysqli_num_rows($result) > 0) {
        $profile_data = mysqli_fetch_assoc($result);
        $profile_firstname = $profile_data['firstname'];
        $profile_lastname = $profile_data['lastname'];
        $profile_email = $profile_data['email'];
        $profile_created_at = $profile_data['created_at'];
    } else {
        header("Location: panel.php");
    }
} else {
    echo "No se especificó un usuario.";
}

mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil de @<?php echo $profile_username; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/estilos.css">
    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon">
</head>

<body>

    <?php require_once 'menu.php'; ?>

    <div class="container mt-0">
        <div class="row sub-menu">
            <div class="col-md-12">
                <?php
                // Obtene el nombre del usuario que ha iniciado sesión
                $nombreCompleto = $_SESSION['firstname'] . ' ' . $_SESSION['lastname'];
                ?>

                <div id="usuario-activo">
                    <!-- Muestra el nombre del usuario en su perfil -->
                    <p class="titulo-bienvenida">Perfil de <?php echo $profile_firstname; ?> <?php echo $profile_lastname; ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-0">
        <div class="row pt-3 pb-3 contenido-web">
            <div class="col-md-12">
                <div class="mt-0">
                    <p class="titulo-msg">@<?php echo $profile_username; ?></p>
                    <div class="row">
                        <div class="col-md-3 mt-3">
                            <img width="200" src="img/avatar-default.png" alt="">
                        </div>
                        <div class="col-md-9 mt-3">
                            <table class="table table-striped">
                                <tbody>
                                    <tr>
                                        <th scope="row" class="col-md-3 tabla-custom">Nombre:</th>
                                        <td class="col-md-9 tabla-custom"><?php echo $profile_firstname; ?> <?php echo $profile_lastname; ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="col-md-3 tabla-custom">Usuario:</th>
                                        <td class="col-md-9 tabla-custom">@<?php echo $profile_username; ?></td>
                                    </tr>
                                    <tr>
                                        <?php
                                        // Zona horaria de Chile para mostrar desde cuando es miambro el usuario
                                        date_default_timezone_set('America/Santiago');
                                        $locale = 'es_ES';
                                        $formatter = new IntlDateFormatter($locale, IntlDateFormatter::LONG, IntlDateFormatter::NONE);
                                        $formatted_created_at = $formatter->format(strtotime($profile_created_at));
                                        ?>

                                        <th scope="row" class="col-md-3 tabla-custom">Miembro desde:</th>
                                        <td class="col-md-9 tabla-custom"><?php echo $formatted_created_at; ?></td>
                                    </tr>
                                </tbody>
                            </table>

                            <?php if ($_SESSION['username'] != $profile_username) : ?>
                                <a href="mensajes.php?user1=<?php echo $_SESSION['username']; ?>&user2=<?php echo $profile_username; ?>" class="btn btn-light btn-sm btn-ver send-message" role="button">
                                    Enviar mensaje
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <div class="row justify-content-center align-items-center custom-footer">
                <div class="col">
                    <p class="m-0">© <?php echo date("Y"); ?> mzChat. Desarrollado por Maxi Zamorano</p>
                </div>
            </div>

        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>