<?php
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// Verifica si se hizo clic en cerrar sesión
if (isset($_GET['logout'])) {
    session_destroy();

    header("Location: login.php");
    exit;
}

// Conexión a la base de datos
require_once 'db.php';

// Función para desencriptar la vista previa de los mensajes
function decryptMessage($encryptedMessage, $key)
{
    $encryptedMessage = base64_decode($encryptedMessage);
    $iv_length = openssl_cipher_iv_length("aes-256-cbc");
    $iv = substr($encryptedMessage, 0, $iv_length);
    $encrypted_message = substr($encryptedMessage, $iv_length);
    return openssl_decrypt($encrypted_message, "aes-256-cbc", $key, OPENSSL_RAW_DATA, $iv);
}

// Procesa el formulario de búsqueda de usuario
if (isset($_POST['search_user'])) {
    $search_query = $_POST['search_query'];
    $search_result = mysqli_query($conn, "SELECT * FROM usuarios WHERE username LIKE '%$search_query%'");
}

// Procesa el envío de mensaje
if (isset($_POST['send_message'])) {
    $recipient_username = $_POST['recipient_username'];
    $check_recipient_query = mysqli_query($conn, "SELECT * FROM usuarios WHERE username = '$recipient_username'");

    if (mysqli_num_rows($check_recipient_query) == 0) {
        $error_message = "El usuario no existe.";
    } else {
        // Inserta el mensaje en la base de datos
        $sender_username = $_SESSION['username'];
        $message_content = $_POST['message_content'];

        $sql = "INSERT INTO mensajes (sender_username, recipient_username, message_content, created_at) VALUES ('$sender_username', '$recipient_username', '$message_content', NOW())";

        if (mysqli_query($conn, $sql)) {
            $success_message = "Mensaje enviado correctamente.";
        } else {
            echo "Error: " . $sql . "<br>" . mysqli_error($conn);
        }
    }
}

// Se obtienen los usuarios con los que se han enviado mensajes
$logged_in_user = $_SESSION['username'];
$users_query = mysqli_query($conn, "SELECT DISTINCT sender_username, recipient_username FROM mensajes WHERE sender_username = '$logged_in_user' OR recipient_username = '$logged_in_user'");

$interacted_users = [];

while ($user = mysqli_fetch_assoc($users_query)) {
    if ($user['sender_username'] == $logged_in_user) {
        $interacted_users[] = $user['recipient_username'];
    } else {
        $interacted_users[] = $user['sender_username'];
    }
}

$interacted_users = array_unique($interacted_users);

// Obtiene los últimos mensajes enviados y recibidos
$messages = [];
foreach ($interacted_users as $user) {
    $message_query = mysqli_query($conn, "SELECT * FROM mensajes WHERE (sender_username = '$logged_in_user' AND recipient_username = '$user') OR (sender_username = '$user' AND recipient_username = '$logged_in_user') ORDER BY created_at DESC LIMIT 1");
    $message = mysqli_fetch_assoc($message_query);
    if ($message) {
        $messages[] = $message;
    }
}

// Ordena los mensajes por fecha
usort($messages, function ($a, $b) {
    return strtotime($b['created_at']) - strtotime($a['created_at']);
});

// Consulta el número total de usuarios registrados
$total_users_query = mysqli_query($conn, "SELECT COUNT(*) as total_users FROM usuarios");
$total_users_result = mysqli_fetch_assoc($total_users_query);
$total_users = $total_users_result['total_users'];

// Consulta el número total de mensajes enviados
$total_messages_query = mysqli_query($conn, "SELECT COUNT(*) as total_messages FROM mensajes");
$total_messages_result = mysqli_fetch_assoc($total_messages_query);
$total_messages = $total_messages_result['total_messages'];

mysqli_close($conn);

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel de Usuario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/estilos.css">
    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon">
</head>
<style>

</style>

<body>

    <?php require_once 'menu.php'; ?>

    <div class="container mt-0">
        <div class="row sub-menu">
            <div class="col-md-12">
                <?php
                // Obtiene el nombre del usuario que ha iniciado sesión
                $nombreCompleto = $_SESSION['firstname'] . ' ' . $_SESSION['lastname'];
                ?>

                <div id="usuario-activo">
                    <!-- Muestra el nombre del usuario en la bienvenida -->
                    <p class="titulo-bienvenida">Bienvenido, <?php echo $nombreCompleto; ?>!</p>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-0">
        <div class="row pt-3 pb-3 contenido-web">
            <div class="col-md-4">
                <!-- Formulario para buscar usuarios -->
                <form action="" method="post">
                    <div class="input-group mb-3">
                        <div class="input-group-text btn-busqueda" id="btnGroupAddon">@</div>
                        <input type="text" class="form-control input-buscar" placeholder="Buscar usuario..." name="search_query" id="search_query">
                        <button class="btn btn-primary btn-buscar" type="submit" name="search_user">Buscar</button>
                    </div>

                </form>

                <!-- Resultados de la búsqueda de usuarios -->
                <?php if (isset($search_result)) : ?>
                    <?php if ($_POST['search_query'] != $_SESSION['username']) : ?>
                        <?php if (mysqli_num_rows($search_result) > 0) : ?>
                            <ul class="list-group tabla-busqueda mb-3">
                                <?php while ($row = mysqli_fetch_assoc($search_result)) : ?>
                                    <?php if ($row['username'] != $_SESSION['username']) : ?>
                                        <li class="list-group-item">
                                            <button class="btn-user-busqueda search-result"><a class="link-users" href="perfil.php?usuario=<?php echo $row['username']; ?>">@<?php echo $row['username']; ?></a></button>
                                            <a href="mensajes.php?user1=<?php echo $_SESSION['username']; ?>&user2=<?php echo $row['username']; ?>" class="btn btn-light btn-sm btn-ver float-end send-message" role="button">
                                                Enviar mensaje
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endwhile; ?>
                            </ul>
                        <?php else : ?>
                            <p style="font-size:14px;padding: 5px 10px;" class="alert alert-danger">No se encontraron usuarios con los términos de búsqueda.</p>
                        <?php endif; ?>
                    <?php else : ?>
                        <p>No se puede buscar el mismo nombre de usuario actual.</p>
                    <?php endif; ?>
                <?php elseif (isset($_POST['search_query'])) : ?>
                    <p>Ocurrió un error al buscar usuarios.</p>
                <?php endif; ?>

                <div>
                    <p class="titulo-msg">Estadísticas</p>
                    <p class="contenido-msg"><b><?php echo $total_users; ?></b> miembros<br>
                        <b><?php echo $total_messages; ?></b> mensajes enviados
                    </p>
                </div>
            </div>



            <div class="col-md-8">
                <!-- Muestra los mensajes enviados y recibidos -->
                <div class="mt-0">
                    <p class="titulo-msg">Mensajes</p>
                    <?php if (empty($messages)) : ?>
                        <div class="alert alert-primary mt-3" role="alert">
                            No tienes ningún mensaje enviado o recibido. ¡Empieza a hablar con algún usuario!
                        </div>
                    <?php else : ?>
                        <?php foreach ($messages as $message) : ?>
                            <?php
                            $user1 = $_SESSION['username'];
                            $user2 = ($message['sender_username'] == $user1) ? $message['recipient_username'] : $message['sender_username'];
                            ?>
                            <!-- Verifica si el mensaje fue leido -->
                            <div class="card-mensajes card mt-3 <?php if ($message['leido'] == 0 && $message['sender_username'] != $_SESSION['username']) : ?>mensaje-nuevo<?php endif; ?>">
                                <p class="user-titulo">@<?php echo $user2; ?> <?php if ($message['leido'] == 0 && $message['sender_username'] != $_SESSION['username']) : ?><span class="badge rounded-pill bg-success badge-nuevo">Nuevo mensaje</span><?php endif; ?> <span class="float-end fecha"><?php echo $message['created_at']; ?></span></p>
                                <div class="card-body">

                                    <p class="card-text vista-mensaje">
                                        <?php
                                        // Desencripta y muestra el mensaje
                                        $key = "YNsHx3tEY9nONenzI5xz8nm2eniyEBPy4uh84UNG577iohVAIe";
                                        $message_content = decryptMessage($message['message_content'], $key);
                                        $truncate_length = 200;

                                        if (strlen($message_content) > $truncate_length) {
                                            $message_content = substr($message_content, 0, $truncate_length) . '...';
                                        }

                                        echo htmlspecialchars($message_content);
                                        ?>
                                    </p>
                                    <a href="mensajes.php?user1=<?php echo $user1; ?>&user2=<?php echo $user2; ?>" class="btn btn-light btn-sm btn-responder">Responder</a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <div class="row justify-content-center align-items-center custom-footer">
                <div class="col">
                    <p class="m-0">© <?php echo date("Y"); ?> mzChat. Desarrollado por Maxi Zamorano</p>
                </div>
            </div>

        </div>
    </footer>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>