<?php
session_start();

// Verifica si hay un mensaje de error específico en la URL
if (isset($_GET['error'])) {
    $error_type = $_GET['error'];
    $error_message = "";

    // Muestra un mensaje de error según el tipo de error que se genere
    switch ($error_type) {
        case "pass_coincidencia":
            $error_message = "Las contraseñas no coinciden.";
            break;
        case "pass_minimo":
            $error_message = "La contraseña debe tener al menos una letra minúscula, una letra mayúscula, un dígito o un carácter especial, y debe tener al menos 8 caracteres de longitud.";
            break;
        case "token_invalido":
            $error_message = "El token de restablecimiento ya ha expirado, solo tiene validez por 15 minutos, solicita el restablecimiento nuevamente.";
            break;
        default:
            $error_message = "Ha ocurrido un error.";
            break;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nueva contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../css/estilos-caja.css">
    <link rel="shortcut icon" href="../img/favicon.png" type="image/x-icon">
</head>

<body>

    <div class="container">
        <h3 class="logo">mzChat</h3>
        <div class="login-container">
            <h4>Nueva contraseña</h4>

            <!-- Formulario de inicio de sesión -->
            <form action="nuevo_pass_procesar.php" method="post">
                <div class="mb-3">
                    <label for="pass" class="form-label mb-0">Nueva contraseña:</label>
                    <input type="password" class="form-control" id="pass" name="password" required>
                </div>
                <div class="mb-3">
                    <label for="pass2" class="form-label mb-0">Repetir Nueva contraseña:</label>
                    <input type="password" class="form-control" id="pass2" name="confirm_password" required>
                </div>
                <input type="hidden" name="email" value="<?php echo $_GET['email']; ?>">
                <input type="hidden" name="token" value="<?php echo $_GET['token']; ?>">
                <button type="submit" class="btn btn-primary btn-acceso" name="submit">Restablecer Contraseña</button>
                <?php if (isset($error_message)) { ?>
                    <div class="alert alert-danger info-error"><?php echo $error_message; ?></div>
                <?php } ?>
            </form>
        </div>
        <p class="copy">© <?php echo date("Y"); ?> mzChat. Desarrollado por Maxi Zamorano</p>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>