<?php
session_start();

// Verifica si el usuario inició sesión
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Conexión a la base de datos
require_once 'db.php';

// Verifica si se hace clic en el boton de cerrar sesión
if (isset($_GET['logout'])) {
    // Destruir la sesión actual
    session_destroy();

    header("Location: login.php");
    exit;
}

// Función para encriptar los mensajes
function encryptMessage($message, $key)
{
    $iv_length = openssl_cipher_iv_length("aes-256-cbc");
    $iv = openssl_random_pseudo_bytes($iv_length);
    $encrypted_message = openssl_encrypt($message, "aes-256-cbc", $key, OPENSSL_RAW_DATA, $iv);
    return base64_encode($iv . $encrypted_message);
}

// Función para desencriptar los mensajes
function decryptMessage($encryptedMessage, $key)
{
    $encryptedMessage = base64_decode($encryptedMessage);
    $iv_length = openssl_cipher_iv_length("aes-256-cbc");
    $iv = substr($encryptedMessage, 0, $iv_length);
    $encrypted_message = substr($encryptedMessage, $iv_length);
    return openssl_decrypt($encrypted_message, "aes-256-cbc", $key, OPENSSL_RAW_DATA, $iv);
}

// Procesamiento del envio de emnsajes
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Verifica si se envió el formulario
    if (isset($_POST['send_message'])) {
        // Verificar si el usuario destino existe en la base de datos
        $recipient_username = $_POST['recipient_username'];
        $check_recipient_query = mysqli_query($conn, "SELECT * FROM usuarios WHERE username = '$recipient_username'");

        if (mysqli_num_rows($check_recipient_query) == 0) {
            // Si el destinatario no existe muestra un mensaje de error
            $error_message = "El usuario destinatario no existe. Por favor, elija un usuario existente.";
        } else {
            // Valida el contenido del mensaje
            $message_content = trim($_POST['message_content']);

            // Verifica si el mensaje no está vacío después de eliminar los espacios en blanco
            if (!empty($message_content)) {
                // Convierte caracteres especiales en entidades HTML para que no afecte la visualización de esos mensajes
                $message_content = htmlspecialchars($message_content);

                // Encripta el mensaje antes de insertarlo en la base de datos, soy conciente de que se podría utilizar una llave más segura almacenada en otros servicios como KMS de AWS
                $key = "YNsHx3tEY9nONenzI5xz8nm2eniyEBPy4uh84UNG577iohVAIe";
                $encrypted_message = encryptMessage($message_content, $key);

                $sender_username = $_SESSION['username'];

                $sql = "INSERT INTO mensajes (sender_username, recipient_username, message_content, created_at) VALUES ('$sender_username', '$recipient_username', '$encrypted_message', NOW())";

                if (mysqli_query($conn, $sql)) {
                    // Mensaje enviado correctamente
                    $success_message = "Mensaje enviado correctamente.";
                    // Llamar a la función para cargar los mensajes más recientes y actualizar el contenedor de conversación
                    echo "<script>cargarMensajesRecientes();</script>";
                } else {
                    $error_message = "Error al enviar el mensaje: " . mysqli_error($conn);
                }
            } else {
                $error_message = "No puedes enviar un mensaje vacío.";
            }
        }
    } else {
        $error_message = "No se recibió ninguna solicitud válida.";
    }
}

// Obtiene el nombre de usuario de la sesión
$current_user = $_SESSION['username'];

// Obtiene los nombres de usuario de la URL
$user1 = $_GET['user1'];
$user2 = $_GET['user2'];

// Verifica si el usuario actual está autorizado para ver esta conversación, asi se evita que se escriban otros usuarios en la URL y se vea la conservación
if ($user1 !== $current_user && $user2 !== $current_user) {
    header("Location: panel.php");
    exit();
}

// Consulta los mensajes entre los dos usuarios
$messages_query = mysqli_query($conn, "SELECT * FROM mensajes WHERE (sender_username = '$user1' AND recipient_username = '$user2') OR (sender_username = '$user2' AND recipient_username = '$user1') ORDER BY created_at ASC");

// Crea un array para almacenar los mensajes
$messages = array();

// Almacena los mensajes en el array
while ($message = mysqli_fetch_assoc($messages_query)) {
    $messages[] = $message;
}

// Marca los mensajes como leídos dondee 1 es leido y 0 es no leido
foreach ($messages as $message) {
    if ($message['recipient_username'] === $current_user && $message['leido'] == 0) {
        $message_id = $message['id'];
        mysqli_query($conn, "UPDATE mensajes SET leido = 1 WHERE id = $message_id");
    }
}

mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mensajes con @<?php echo $user2; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/estilos.css">
    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon">
</head>

<body>

    <?php require_once 'menu.php'; ?>
    <div class="container mt-0">
        <div class="row sub-menu">
            <div class="col-md-12">
                <?php
                $nombreCompleto = $_SESSION['firstname'] . ' ' . $_SESSION['lastname'];
                ?>
                <div id="usuario-activo">
                    <p class="titulo-bienvenida">Mensajes con @<?php echo $user2; ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="container container-titulo-usuario mb-4 mt-0">
        <div class="row">
            <div class="col-sm-12">
                <p class="titulo-usuario">@<?php echo $user2; ?> <span style="font-size:12px;" class="badge bg-success"><a style="color:#fff;text-decoration:none" href="perfil.php?usuario=<?php echo $user2; ?>">Ver perfil</a></span>
                </p>
                <p class="subtitulo-usuario">Lista de mensajes con este usuario</p>
            </div>
        </div>
    </div>

    <div class="container container-chat" id="conversation-container">
        <?php if (count($messages) > 0) : ?>
            <?php foreach ($messages as $message) : ?>
                <div style="border:0" class="card message-card <?php echo $message['sender_username'] === $current_user ? 'mensaje-user-actual' : ''; ?>">
                    <div class="card-body contenedor-mensaje">
                        <h5 class="card-title nombre-user">@<?php echo $message['sender_username']; ?></h5>
                        <p class="card-text <?php echo $message['sender_username'] === $current_user ? 'mensaje-propio' : 'caja-mensajes'; ?>">
                            <?php
                            // Desencripta y muestra el mensaje
                            $key = "YNsHx3tEY9nONenzI5xz8nm2eniyEBPy4uh84UNG577iohVAIe";
                            echo htmlspecialchars(decryptMessage($message['message_content'], $key));
                            ?>
                        </p>
                        <p class="card-text fecha-hora-mensajes"><?php echo $message['created_at']; ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else : ?>
            <div class="alert alert-primary" role="alert">
                No tienes mensajes con este usuario. ¡Escríbele un mensaje!
            </div>
        <?php endif; ?>
    </div>

    <!-- Formulario para enviar mensajes entre los usuarios -->
    <div class="container enviar-mensaje mt-0">
        <?php if (isset($error_message)) : ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $error_message; ?>
            </div>
        <?php endif; ?>
        <form id="messageForm" method="post">
            <input type="hidden" name="recipient_username" value="<?php echo $user1 === $current_user ? $user2 : $user1; ?>">
            <div class="input-group mb-3">
                <textarea class="form-control input-enviar" id="message_content" name="message_content" rows="1" required autofocus placeholder="Escribe tu mensaje..." style="resize: none; overflow-y: hidden;"></textarea>
                <button type="submit" class="btn btn-primary btn-enviar" id="sendMessageBtn" name="send_message">Enviar</button>
            </div>
        </form>
    </div>

    <footer class="text-center">
        <div class="container">
            <div class="row justify-content-center align-items-center custom-footer">
                <div class="col">
                    <p class="m-0">© <?php echo date("Y"); ?> mzChat. Desarrollado por Maxi Zamorano</p>
                </div>
            </div>

        </div>
    </footer>

    <script>
        // Función para cargar los mensajes nuevos mediante y se actualizen en vivo
        function loadNewMessages() {
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function() {
                if (xhr.readyState === XMLHttpRequest.DONE) {
                    if (xhr.status === 200) {
                        document.getElementById('conversation-container').innerHTML = xhr.responseText;
                        var conversationContainer = document.getElementById('conversation-container');
                        conversationContainer.scrollTop = conversationContainer.scrollHeight;
                    } else {
                        console.error('Error al cargar los mensajes: ' + xhr.statusText);
                    }
                }
            };
            xhr.open('GET', 'mensajes_en_vivo.php?user1=<?php echo $user1; ?>&user2=<?php echo $user2; ?>', true);
            xhr.send();
        }

        // Actualiza los mensajes cada cierto intervalo de tiempo, en este caso 3 segundos
        setInterval(loadNewMessages, 3000);

        // Ajusta la altura del área de texto
        document.getElementById("message_content").addEventListener("input", function() {
            this.style.height = "auto";
            this.style.height = (this.scrollHeight) + "px";
        });

        // Envia el mensaje al presionar la tecla enter
        document.getElementById("message_content").addEventListener("keypress", function(event) {
            if (event.key === "Enter") {
                event.preventDefault();
                document.getElementById("sendMessageBtn").click();
            }
        });

        // El scroll a la parte inferior para que siempre se vean los ultimos mensajes
        var conversationContainer = document.getElementById('conversation-container');
        conversationContainer.scrollTop = conversationContainer.scrollHeight;
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>