<?php
session_start();

// Verifica si el usuario ya tiene una sesión iniciada
if (isset($_SESSION['username'])) {
    header("Location: panel.php"); 
    exit();
}

if (isset($_GET['login']) && $_GET['login'] === 'error') {
    $error_message = "Usuario o contraseña incorrecto.";
} else {
    $error_message = "";
}

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/estilos-caja.css">
    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon">
</head>

<body>
    <div class="container">
        <h3 class="logo">mzChat</h3>
        <div class="login-container">
            <h4>Iniciar sesión</h4>
            <!-- Formulario de inicio de sesión -->
            <form class="login-form" action="acceso/login_proceso.php" method="post">
                <div class="mb-1">
                    <label for="loginUsername" class="form-label mb-0">Nombre de usuario:</label>
                    <input type="text" class="form-control" id="loginUsername" name="username" required>
                </div>
                <div class="mb-1">
                    <label for="loginPassword" class="form-label mb-0">Contraseña:</label>
                    <input type="password" class="form-control" id="loginPassword" name="password" required>
                    <div style="margin-top:0;" class="links text-end">
                        <a href="restablecer/restablecer_pass.php">¿Olvidaste tu contraseña?</a>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary btn-acceso" name="login">Iniciar sesión</button>
                <!-- Muestra el mensaje de error si existe -->
                <?php if (!empty($error_message)) { ?>
                    <div class="alert alert-danger info-error"><?php echo $error_message; ?></div>
                <?php } ?>

            </form>

            <div class="links">
                <a href="registro.php">¿No tienes una cuenta? Regístrate</a>
            </div>
        </div>
        <p class="copy">© <?php echo date("Y"); ?> mzChat. Desarrollado por Maxi Zamorano</p>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>