<?php
session_start();

if(isset($_POST['login'])) {
    
    require_once '../db.php';

    // Obtiene los valores del formulario y los limpia
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = mysqli_real_escape_string($conn, $_POST['password']);

    // Consulta preparada para evitar la inyección SQL
    $query = "SELECT * FROM usuarios WHERE BINARY username = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 's', $username);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if(mysqli_num_rows($result) == 1) {
        $row = mysqli_fetch_assoc($result);
        if(password_verify($password, $row['password'])) {
            
            // Consulta para evitar la inyección SQL
            $query = "SELECT firstname, lastname, email, created_at FROM usuarios WHERE username = ?";
            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($stmt, 's', $username);
            mysqli_stmt_execute($stmt);
            $user_result = mysqli_stmt_get_result($stmt);

            if ($user_row = mysqli_fetch_assoc($user_result)) {
                
                $_SESSION['firstname'] = $user_row['firstname'];
                $_SESSION['lastname'] = $user_row['lastname'];
                $_SESSION['email'] = $user_row['email'];
                $_SESSION['created_at'] = $user_row['created_at'];
            }
            
            $_SESSION['username'] = $username;
            header("Location: ../panel.php");
            exit;
        } else {
            
            header("Location: ../login.php?login=error");
            exit;
        }
    } else {
        
        header("Location: ../login.php?login=error");
        exit;
    }
    
    mysqli_close($conn);
} else {
    
    header("Location: ../login.php");
    exit;
}
?>
